	
	// Filter FocusColor
#define rgb2Gray_table(Y,R,G,B) {	\
(Y) = ((R + G + B + 512) >> 10);	\
}

__kernel void filter_FocusColor(__read_only image2d_t image,   		// input buffer image
								__read_only image2d_t merge,   		// image input merge
								__global int* tableR,   			// input buffer tableR
								__global int* tableG,   			// input buffer tableG
								__global int* tableB,   			// input buffer tableB
								__write_only image2d_t retImage,  	// output ruffer result
							    __private int left,
							    __private int right,
							    __private int top,
							    __private int buttom,
							    __private int cx,
							    __private int cy,
							    __private int offBytes,
						        __private int alpha)	 			// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);

	if(w >= width || h >= height)
			return;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	

	float factor = (float)(alpha)/100.0f;
	float2 uv = (float2)((float)(w) / width, (float)(h) / height);
	float4 color = read_imagef(image, sampler, uv);
	uchar sr = color.x * 255;
	uchar sg = color.y * 255;
	uchar sb = color.z * 255;
	uchar ret_b, ret_g, ret_r;
	
	if((w >= left) && (w <= right) && (h >= top) && (h <= buttom))
	{
		int aXind, aYind, offNum, gray, iOlaGray;
					aXind = ((cy - h) * width * 4) >> 2;
					aYind = w - cx;
		offNum = (offBytes >> 2) + (aXind + aYind);
		int mw = offNum / width, mh = offNum % width;
		float4 color = read_imagef(merge, sampler, uv);
		uchar iC = color.z * 255;
					int iG = 256 - iC;
		 
		int tr = tableR[sr];
		int tg = tableG[sg];
		int tb = tableB[sb];

		rgb2Gray_table(gray, tr, tg, tb);
		iOlaGray = gray*iG;
		
		tb = (iC * sb + iOlaGray) >> 8;
		tg = (iC * sg + iOlaGray) >> 8;
		tr = (iC * sr + iOlaGray) >> 8;
		
		ret_b = (uchar)(tb * factor + (1.0f - factor) * sb);
		ret_g = (uchar)(tg * factor + (1.0f - factor) * sg);
		ret_r = (uchar)(tr * factor + (1.0f - factor) * sr);
	}
	else
	{
		int gray;
		int tb, tg, tr;
		tb = tableB[sb]; tg = tableG[sg]; tr = tableR[sr];
		rgb2Gray_table(gray, tr, tg, tb);
		
		ret_b = (uchar)(gray * factor + (1.0f - factor) * sb);
		ret_g = (uchar)(gray * factor + (1.0f - factor) * sg);
		ret_r = (uchar)(gray * factor + (1.0f - factor) * sr);
	}
	
	write_imagef(retImage, (int2)(w, h), (float4)(ret_r / 255.0f, ret_g / 255.0f, ret_b / 255.0f, color.w));
}

// Filter FreshNew
#define ChannelBlend_Exclusion(B,L)  ((B + L - ((B * L) >> 7)))

__kernel void filter_FreshNew(__read_only image2d_t image,   		// input buffer image
							  __global uchar* tableR,   			// input buffer table R
							  __global uchar* tableG,   			// input buffer table G
							  __global uchar* tableB,   			// input buffer table B
							  __write_only image2d_t retImage,  	// output ruffer result
						      __private int alpha)	 				// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);

	if(w >= width || h >= height)
			return;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	

	float4 color = read_imagef(image, sampler, (int2)(w, h));
	int r = color.x * 255;
	int g = color.y * 255;
	int b = color.z * 255;
	
	r = ChannelBlend_Exclusion(r, 31);
	g = ChannelBlend_Exclusion(g, 25);
	b = ChannelBlend_Exclusion(b, 81);
	
	r = (int)(tableR[r]);
	g = (int)(tableG[g]);
	b = (int)(tableB[b]);
	
	float factor = (float)(alpha)/100.0f;
	
	float ret_b = b * factor / 255.0f + (1.0f - factor) * color.x;
	float ret_g = g * factor / 255.0f + (1.0f - factor) * color.y;
	float ret_r = r * factor / 255.0f + (1.0f - factor) * color.z;
	
	write_imagef(retImage, (int2)(w, h), (float4)(ret_r, ret_g, ret_b, color.w));
}

// Filter GetColor
#define MIN3(x,y,z)  ((y) <= (z) ? \
((x) <= (y) ? (x) : (y)) \
: \
((x) <= (z) ? (x) : (z)))

#define MAX3(x,y,z)  ((y) >= (z) ? \
((x) >= (y) ? (x) : (y)) \
: \
((x) >= (z) ? (x) : (z)))

ushort HueFromRGB_Int_Opt(uchar r, uchar g, uchar b, __global int* g_DiffInvArray)
{
	int rgb_min, rgb_max;
	int diff = 0;
	ushort hue = 0;
	int diffInvVal = 0;
    
	rgb_min = r < g ? ((b < r) ? b : r) : ((b < g) ? b : g); 
	rgb_max = r > g ? ((b > r) ? b : r) : ((b > g) ? b : g); 
	diff = rgb_max - rgb_min;
    int ir = r, ig = g, ib = b;
    
	//when the input r,g,b is gray, set the gray info
	if(rgb_max == 0 || diff <= 20)
	{
		hue = 512;
		return hue;
	}
    
	diffInvVal = g_DiffInvArray[diff];
        
	/* Compute hue */
	if (rgb_max == ir)
	{
		if(ig >= ib)
			hue = 0 + ((diffInvVal * (ig - ib)) >> 20);
		else
			hue = 255 - ((diffInvVal * (ib - ig)) >> 20);
	}
	else if(rgb_max == ig)
	{
        hue = 85 + ((diffInvVal * (ib - ir)) >> 20);
	}
	else /* rgb_max == ib */
	{
        hue = 171 + ((diffInvVal * (ir - ig)) >> 20);
	}
    
	return hue;
}

__kernel void filter_GetColor(__read_only image2d_t image,   		// input buffer image
							  __global int* table,   				// input buffer table
							  __write_only image2d_t retImage,  	// output ruffer result
							  __private uchar maxHue0,
							  __private uchar minHue0,
							  __private uchar maxHue1,
							  __private uchar minHue1,
							  __private int bTwoRange,
						      __private int alpha,
                              __private int GrayProcess)	 				// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);

	if(w >= width || h >= height)
			return;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;

	float4 color = read_imagef(image, sampler, (int2)(w, h));
	uchar sr = (uchar)(color.x * 255);
	uchar sg = (uchar)(color.y * 255);
	uchar sb = (uchar)(color.z * 255);

	float factor = (float)(alpha)/100.0f;
    if(GrayProcess){
        uchar tempGrayVal = (sr * 306 + sg * 601 + sb * 117 + 512) >> 10;
        uchar b = (uchar)(tempGrayVal * factor + (1.0f - factor) * sb);
        uchar g = (uchar)(tempGrayVal * factor + (1.0f - factor) * sg);
        uchar r = (uchar)(tempGrayVal * factor + (1.0f - factor) * sr);
            
        write_imagef(retImage, (int2)(w, h), (float4)(r / 255.0f, g / 255.0f, b / 255.0f, color.w)); 
    }else{
        ushort curHue = HueFromRGB_Int_Opt(sr, sg, sb, table);
        bool bs = false;

        if(!bTwoRange)
            bs = (curHue != 512 && (curHue > maxHue0 || curHue < minHue0));
        else
            bs = (curHue != 512 && !((curHue <= maxHue0 && curHue >= minHue0) || (curHue <= maxHue1 && curHue >= minHue1)));
            
        if(bs)
        {
            uchar tempGrayVal = (sr * 306 + sg * 601 + sb * 117 + 512) >> 10;
            
            uchar b = (uchar)(tempGrayVal * factor + (1.0f - factor) * sb);
            uchar g = (uchar)(tempGrayVal * factor + (1.0f - factor) * sg);
            uchar r = (uchar)(tempGrayVal * factor + (1.0f - factor) * sr);
            
            write_imagef(retImage, (int2)(w, h), (float4)(r / 255.0f, g / 255.0f, b / 255.0f, color.w));
        }
        else
        {
            write_imagef(retImage, (int2)(w, h), color);
        }	
    }
	
}